unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    S: TImage;
    Button1: TButton;
    Button2: TButton;
    PORTS: TComboBox;
    Label2: TLabel;
    Button3: TButton;
    PIN: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PINClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  // COM 
  COM: Cardinal;
  // 
  Thread: Integer;
  ThreadId: Cardinal;
  INVERTOR: Byte;

  Obj: TForm1;
  CTS, Mask: DWORD;
  // 
  Pause, Pulse: Double;
  ClockRate: Double;
  ET: LARGE_INTEGER;
  // 
  BITS: Integer;
  A, B, C, D, F, I, Z, K: Byte;
  IMG: TCanvas;
  V: WORD;
  DATA: array[1..33] of Byte;
  DATAP: array[1..33] of Byte;

implementation

{$R *.dfm}
procedure DRAWPULSE;
begin
         if BITS = 32 then  //   32 ,  
         begin

           if A = not B then
           if C = not D then
           begin

             Obj.Memo1.Lines.Add(Format(': %.2x :%.2x', [A, C]));
             IMG.Brush.Color := 0;
             IMG.FillRect(IMG.ClipRect);

             
             V := 10;
             Img.MoveTo(V, 10);
             I := 0;

             for Z := 1 to 33 do
             begin
             
               case Datap[Z] of
               8,9:
               begin
                   IMG.Brush.Color := clFuchsia;
                   IMG.Pen.Color := clFuchsia;
                   IMG.Rectangle(V, 5, V + 60, 30);
                   INC(V, 60);
               end;
               0:
               begin
                   if Z > 16 then
                   begin
                     IMG.Brush.Color := clBlack;
                     IMG.Pen.Color := clAqua;
                     IMG.Rectangle(V, 5, V + 8, 30);
                     IMG.Pen.Color := clBlack;
                     IMG.Rectangle(V+1, 20, V + 7, 30);
                   end else
                   begin
                     IMG.Brush.Color := clBlack;
                     IMG.Pen.Color := clYellow;
                     IMG.Rectangle(V, 5, V + 8, 30);
                     IMG.Pen.Color := clBlack;
                     IMG.Rectangle(V+1, 20, V + 7, 30);
                   end;



                   INC(V, 8);
               end;
               end;

               case Data[Z] of
                 0:
                 begin
                   IMG.Brush.Color := ClLime;
                   IMG.Pen.Color := ClLime;
                   IMG.Rectangle(V, 23, V + 10, 30);
                   INC(V, 10);
                 end;
                 1:
                 begin
                   IMG.Brush.Color := ClRed;
                   IMG.Pen.Color := Clred;
                   IMG.Rectangle(V, 23, V + 20, 30);
                   INC(V, 20);
                 end;
                 4:
                 begin
                   IMG.Brush.Color := clFuchsia;
                   IMG.Pen.Color := clFuchsia;
                   IMG.Rectangle(V, 23, V + 30, 30);
                   INC(V, 30);
                 end;
               end;
             end;

           end;
         sleep(50); //  
         end;
end;



//      ,       .

procedure Processing(Parameter: Pointer);

  procedure VSHL(var H: byte);
  begin
    H := H shr 1;
    if F = 1 then
      H := H xor 128;
  end;

begin
  Obj := TForm1(Parameter);

  IMG := Obj.S.Canvas;

  //  ()
  Mask := EV_CTS;
  SetCommMask(COM, Mask);

  QueryPerformanceFrequency(Int64(ET));
  ClockRate := ET.QuadPart;

  INVERTOR := 0;
  BITS := 0;
  Pause := 0;
  I := 0;
  K := 0;
  Pulse := 0;
  ZeroMemory(@Data, Length(Data));
  ZeroMemory(@Datap, Length(Datap));

  repeat
    WaitCommEvent(COM, Mask, nil); //  
    GetCommModemStatus(COM, CTS); //   

    if CTS = 0 then // 
    begin
      QueryPerformanceCounter(Int64(ET));
      Pulse := ET.QuadPart;
      F := Trunc(1000 * (Pulse - Pause) / ClockRate);

      if I > 32 then
        I := 0;
      if (F = 4) and (I <> 0) then
        I := 0;
      if F <> 2 then
      begin
        Inc(I);
        Data[I] := F;
      end;

      case F of
        2: //  
          begin
            if BITS = 32 then //   ,   
              Obj.Memo1.Lines.Add(Format(': %.2x :%.2x', [A, C]) +
                ' REPEAT');
          end;

        4: // 
          begin
            BITS := 0;
          end;

        0, 1: //  
          begin
            // 
            if BITS = 32 then
            begin
              BITS := 0;
              //  
              DRAWPULSE;
            end;

            Inc(BITS); //  
            case BITS of //  
              1..8: VSHL(A);
              9..16: VSHL(B);
              17..24: VSHL(C);
              25..32: VSHL(D);
            end;

          end;
      end;

    end
    else
    begin // 
      QueryPerformanceCounter(Int64(ET));
      Pause := ET.QuadPart; //    
      F := Trunc(1000 * (Pause - Pulse) / ClockRate);

      if (F = 7) and (K <> 0) then
        K := 0;
      if (F = 8) and (K <> 0) then
        K := 0;
      if (F = 9) and (K <> 0) then
        K := 0;
      if (F = 10) and (K <> 0) then
        K := 0;

      if K > 32 then
        K := 0;

      Inc(K);
      Datap[K] := F;
    end;

  until False;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  S.Canvas.Brush.Color := 0;
  S.Canvas.FillRect(s.Canvas.ClipRect);
end;

procedure EnumComPorts(Ports: TStrings);
var
  KeyHandle: HKEY;
  ErrCode, Index: Integer;
  ValueName, Data: string;
  ValueLen, DataLen, ValueType: DWORD;
  TmpPorts: TStringList;
  CODE: Cardinal;
begin
  ErrCode := RegOpenKeyEx(HKEY_LOCAL_MACHINE, 'HARDWARE\DEVICEMAP\SERIALCOMM',
    0, KEY_READ, KeyHandle);
  if ErrCode <> ERROR_SUCCESS then
  begin
    Form1.Memo1.Lines.Add('    ');
    Exit;
  end;

  TmpPorts := TStringList.Create;
  try
    Index := 0;
    repeat
      ValueLen := 256;
      DataLen := 256;
      SetLength(ValueName, ValueLen);
      SetLength(Data, DataLen);
      ErrCode := RegEnumValue(KeyHandle, Index, PChar(ValueName),
{$IFDEF VER120}
        Cardinal(ValueLen),
{$ELSE}
        ValueLen,
{$ENDIF}
        nil, @ValueType, PByte(PChar(Data)), @DataLen);
      if ErrCode = ERROR_SUCCESS then
      begin
        SetLength(Data, DataLen);

        COM := CreateFile(PChar('\\.\' + Data), //  
          GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);

        if COM = INVALID_HANDLE_VALUE then
        begin
          CODE := GetLastError;
          case CODE of
            ERROR_FILE_NOT_FOUND:
              Form1.Memo1.Lines.Add('   COM-:' +
              Data);
            ERROR_ACCESS_DENIED:
              Form1.Memo1.Lines.Add('   :' + Data);
            ERROR_SHARING_VIOLATION:
              Form1.Memo1.Lines.Add('  :' + Data);
          end;
          CloseHandle(COM);
        end
        else
        begin
          Form1.Memo1.Lines.Add(' :' + Data);
          CloseHandle(COM);
          TmpPorts.Add(Data);
        end;

        Inc(Index);
      end
      else if ErrCode <> ERROR_NO_MORE_ITEMS then
      begin
        Form1.Memo1.Lines.Add('    ');
        Exit;
      end;

    until (ErrCode <> ERROR_SUCCESS);
    TmpPorts.Sort;
    Ports.Assign(TmpPorts);
  finally
    RegCloseKey(KeyHandle);
    TmpPorts.Free;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Process: Cardinal;
begin
  if PORTS.Text = '' then
    Exit;
  Button1.Enabled := Button2.Enabled;
  Button2.Enabled := not Button1.Enabled;

  COM := CreateFile(PChar('\\.\' + PORTS.Text), //  
    GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);

  if COM = INVALID_HANDLE_VALUE then
  begin
    if GetLastError = ERROR_FILE_NOT_FOUND then
      Memo1.Lines.Add('   COM-')
    else if GetLastError = ERROR_ACCESS_DENIED then
      Memo1.Lines.Add('   ');
    Exit;
  end;

  Sleep(500); //   , 

  Memo1.Lines.Add(' : ' + PORTS.Text);

  Thread := BeginThread(nil, 0, @Processing, Self, 0, ThreadId); //  
  SetThreadPriority(Thread, THREAD_PRIORITY_TIME_CRITICAL); //  
  Process := GetCurrentProcess(); //  
  SetPriorityClass(Process, REALTIME_PRIORITY_CLASS);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button1.Enabled := Button2.Enabled;
  Button2.Enabled := not Button1.Enabled;
  TerminateThread(Thread, 0);
  CloseHandle(COM);
  //Memo1.Lines.Clear;
  Memo1.Lines.Add(':' + PORTS.Text);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if not Button1.Enabled then
    Button2.Click;
  PORTS.Clear;
  EnumComPorts(PORTS.Items);

  if PORTS.Items.Count > 0 then
  begin
    PORTS.Text := PORTS.Items[0];
    Memo1.Lines.Add(IntToStr(PORTS.Items.Count) + '  .');
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Button3.Click;
  Button1.Click;
end;

procedure TForm1.PINClick(Sender: TObject);
begin
  if PIN.Checked then
    INVERTOR := 16
  else
    INVERTOR := 0;
end;

end.

